package cn.com.duiba.live.mall.api.dto.shopgoods;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import cn.com.duiba.live.mall.api.util.BigDecimalSerializer;
import lombok.Data;

/**
 * 商品表
 * @author youqian mybatis generator 
 * 2020-04-03
 */
@Data
public class ShopGoodsDto implements Serializable {
    private static final long serialVersionUID = 15859022044355845L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long shopGoodsId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleteStatus;

    /**
     * 商品类型 0-实物
     */
    private Integer goodsType;

    /**
     * 显示排序
     */
    private Integer displayOrder;

    /**
     * 商品名称
     * max length = 50
     */
    private String goodsName;

    /**
     * 商品短名称
     * max length = 20
     */
    private String shortName;

    /**
     * 商品图oss
     * max length = 100
     */
    private String goodsThumb;

    /**
     * 商品详情
     * max length = 255
     */
    private String goodsContent;

    /**
     * 商品描述
     * max length = 255
     */
    private String goodsDescription;

    /**
     * 商品编号
     * max length = 255
     */
    private String goodsSn;

    /**
     * 商品原价
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal productPrice;

    /**
     * 商品现价
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal marketPrice;

    /**
     * 商品成本
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal costPrice;

    /**
     * 显示库存 1显示 0 不显示
     */
    private Byte showTotal;

    /**
     * 减库存方式 0 拍下减库存 1 付款减库存 2 永不减库存
     */
    private Integer totalCnf;

    /**
     * 已售出数
     */
    private Integer salesCount;

    /**
     * 实际售出数
     */
    private Integer salesReal;

    /**
     * 商户id
     */
    private Long companyId;

    /**
     * 规格数量
     */
    private Integer skuCount;

    /**
     * 转发数
     */
    private Integer shareCount;

    /**
     * 规格编号自增数
     */
    private Integer specNumberIncr;


    /**
     * 是否需要二次预约
     */
    private Byte needOrder;

    /**
     * 有截止日期的情况
     */
    private Date expireDate;

    /**
     * 销售状态
     */
    private Byte saleStatus;

    /**
     *兑换按钮文案
     */
    private String buyButtonText;

    /**
     *是否需要审核
     */
    private Byte needReview;

    /**
     *运费类型 1统一运费  2运费模板
     */
    private Byte freightType;

    /**
     *统一运费价格
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal freightAmount;

    /**
     * 模版ID
     */
    private Long freightTemplateId;

    /**
     *代发货文案
     */
    private String waitShipText;
}