package cn.com.duiba.live.mall.api.dto.shopgoods;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 商品sku表
 ps:
 sku=stock keeping uint(库存量单位)，
 为保存库存控制的最小可用单位，
 例如一件T恤中一个SKU通常由颜色、尺码组成
 * @author youqian mybatis generator 
 * 2020-03-31
 */
@Data
public class ShopGoodsSkuDto implements Serializable {
    private static final long serialVersionUID = 15856513457005496L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long shopGoodsSkuId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 商品id
     */
    private Long goodsId;

    /**
     * 库存
     */
    private Integer total;

    /**
     * 编号
     * max length = 255
     */
    private String sn;

    /**
     * 名称
     * max length = 100
     */
    private String name;

    /**
     * 商品规格码
     * max length = 255
     */
    private String goodsSpecCode;

    /**
     * 规格字符串
     * max length = 255
     */
    private String specToString;

    /**
     * 价格
     */
    private BigDecimal price;

    /**
     * 商户id
     * not null default = null
     */
    private Long merchantId;

    /**
     * 库存规格
     */
    private Integer totalSpec;
}