package cn.com.duiba.live.mall.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/1/6
 * @description 是否是买家
 */
@Getter
public enum EnumBuyer {

    /**
     * 是否是买家
     */
    BUYER((byte) 0, "买家"),
    SELLER((byte) 1, "卖家"),
    ;

    private byte code;

    private String desc;

    EnumBuyer(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static boolean isBuyer(Byte code) {
        return Objects.equals(BUYER.code, code);
    }

    public static boolean isSeller(Byte code) {
        return Objects.equals(SELLER.code, code);
    }

}
