package cn.com.duiba.live.mall.api.enums.order;

import lombok.Getter;

@Getter
public enum EnumBookingDoTypes {
    BOOKING_UNDO((byte) 0, "状态未变更"),
    BOOKING_PASS((byte) 1, "通过预约"),
    BOOKING_CANCEL((byte) 2, "取消预约"),
    ;

    EnumBookingDoTypes(byte code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private final byte code;
    private final String msg;

    public static EnumBookingDoTypes get(Byte code){
        for(EnumBookingDoTypes doTypes:values()){
            if(doTypes.getCode() == code){
                return doTypes;
            }
        }
        return BOOKING_PASS;
    }
}
