package cn.com.duiba.live.mall.api.enums.order;

import lombok.Getter;

@Getter
public enum EnumBookingStatus {

    WAIT_ORDER((byte) 0, "预约中"),
    WAIT_USE((byte) 1, "待使用"),
    USED((byte) 2, "已使用"),

    ;

    EnumBookingStatus(byte code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private final byte code;
    private final String msg;

    public static EnumBookingStatus get(Byte code){
        for(EnumBookingStatus bookingStatus:values()){
            if(bookingStatus.getCode() == code){
                return bookingStatus;
            }
        }
        return WAIT_USE;
    }

}
