package cn.com.duiba.live.mall.api.enums.order;

import lombok.Getter;

@Getter
public enum EnumExpireStatus {


    EXPIRE_ZERO((byte) 0, "正常无过期"),
    EXPIRE_SOME((byte) 1, "有过期"),
    EXPIRE_ALL((byte) 3, "全部过期"),
    ;

    EnumExpireStatus(byte code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private final byte code;
    private final String msg;

    public static EnumExpireStatus get(Byte code){
        for(EnumExpireStatus expireStatus:values()){
            if(expireStatus.getCode() == code){
                return expireStatus;
            }
        }
        return EXPIRE_ZERO;
    }


}
