package cn.com.duiba.live.mall.api.enums.order;

import lombok.Getter;

/**
 * @author fss
 */
@Getter
public enum EnumGoodsReview {

    NOT_REVIEW((byte) 0, "无需审核"),
    NEED_REVIEW((byte) 1, "需要审核"),
    ;

    EnumGoodsReview(byte code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private final byte code;
    private final String msg;

    public static EnumGoodsReview get(Byte code){
        for(EnumGoodsReview goodsTypes:values()){
            if(goodsTypes.getCode() == code){
                return goodsTypes;
            }
        }
        return NEED_REVIEW;
    }

}
