package cn.com.duiba.live.mall.api.enums.order;

import lombok.Getter;

@Getter
public enum EnumOrderTypes {

    FASHION((byte) 0, "服装类"),
    TOUR((byte) 1, "旅游类"),
    ;


    EnumOrderTypes(byte code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private final byte code;
    private final String msg;

    public static EnumOrderTypes get(Byte code){
        for(EnumOrderTypes orderTypess:values()){
            if(orderTypess.getCode() == code){
                return orderTypess;
            }
        }
        return FASHION;
    }

}
