package cn.com.duiba.live.mall.api.params.goods;

import cn.com.duiba.live.mall.api.params.PageParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 获取商品列表所需参数
 * Created by hong
 * time 2020/4/3.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class GoodsListGetParam extends PageParam {
    private static final long serialVersionUID = -8106203672079036020L;

    /**
     * 标签id列表
     */
    private List<Long> tagIds;

    /**
     * 商品名称
     */
    private String     name;

    /**
     * 商品货号
     */
    private String shortName;

    /**
     * 上新
     */
    private Byte    newPublish;

    /**
     * 爆款
     */
    private Byte    hot;

    /**
     * 促销
     */
    private Byte    discount;

    /**
     * 商品id集合
     */
    private List<Long> goodsIds;

    /**
     * 直播间ID
     */
    private Long liveRoomId;

    private List<Byte> types;

    private List<Byte> saleStatus;

    /**
     * 公司id
     */
    private Long companyId;
}
