package cn.com.duiba.live.mall.api.response;

import cn.com.duiba.live.mall.api.util.BigDecimalSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/7
 * @description
 */
@Data
public class OrderItemDetail implements Serializable {

    /**
     * 商品ID
     */
    private Long goodsId;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品款号
     */
    private String shortName;

    /**
     * 单位
     */
    private String unit;

    /*
     * 过期状态 0-正常 1-有过期 3-全过期
     */
    private Byte expireStatus;

    /**
     * 商品图片
     */
    private String goodsImage;

    /**
     * 商品单价
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal unitPrice;

    /**
     * 商品小计
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal totalPrice;

    /**
     * 商品总数量
     */
    private Integer totalCount = 0;

    /**
     * 订单项ID
     * not null default = 0
     */
    private Long orderItemId;
//
//    /**
//     * 商品货号
//     */
//    private String goodsSpecCode;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * skuName
     */
    private String skuName;

    /**
     * 数量
     */
    private Integer num;

    /**
     * 单价
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal price;

    /**
     * 商品颜色
     */
    private String color;

    /**
     * 商品大小
     */
    private String size;

    /**
     * 待使用数量
     */
    private Integer waitUseNum;
//    /**
//     * 商品类型 0-不需要预约 1-要预约
//     */
//    private Byte goodsType;
//
    /**
     * 商品详情
     */
    private List<OrderItemResult> skuList;
}
