package cn.com.duiba.live.mall.api.response;

import cn.com.duiba.live.mall.api.dto.order.OrderRefundMoneyDto;
import cn.com.duiba.live.mall.api.util.BigDecimalSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/3/26
 * @description
 */
@Data
public class OrderItemResult implements Serializable {

    /**
     * 订单项ID
     * not null default = 0
     */
    private Long orderItemId;

    /**
     * 商品款号
     */
    private String shortName;

    /**
     * 商品货号
     */
    private String goodsSpecCode;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * skuName
     */
    private String skuName;

    /**
     * 数量
     */
    private Integer num;

    /**
     * 单价
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal price;

    /**
     * 总价格
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal totalPrice;

    /**
     * 单位
     */
    private String unit;

    /**
     * 商品颜色
     */
    private String color;

    /**
     * 商品大小
     */
    private String size;

    /**
     * 有效期
     */
    private Date expireDate;

//    /**
//     * 商品类型 0-不需要预约 1-要预约
//     */
//    private Byte goodsType;

    /**
     * 库存位
     */
    private Integer placeNum;

//    /**
//     * 限制预约时间
//     */
//    private List<String> disableDate;
//
//    /**
//     * sku 下已申请退款记录
//     */
//    private List<OrderRefundMoneyDto> refundMoneys;
//
//    /**
//     * sku 下已申请预约记录
//     */
//    private List<OrderBookingDto> bookings;

    /**
     * 待使用数量
     */
    private Integer waitUseNum;

    /**
     * 过期状态
     */
    private Byte expireStatus;
}
