package cn.com.duiba.live.mall.api.util;

import cn.com.duiba.live.mall.api.response.OrderDetail;
import cn.com.duiba.live.mall.api.response.OrderPageResult;
import cn.com.duiba.live.mall.api.response.OrderRefundMoneyPageResult;
import org.apache.commons.collections4.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

/**
 * @Author: fss
 * @Date: 2021/8/13 17
 * @Description:
 */
public class BigDecimalUtils {

    /**
     * BigDecimal(单位元)数据转Long(单位分)
     */
    public static Long getBigDecimalToLong(BigDecimal bigDecimal) {
        if (Objects.isNull(bigDecimal)) {
            return null;
        }
        return bigDecimal.multiply(new BigDecimal(100)).longValue();
    }

    /**
     * BigDecimal(单位元)数据转BigDecimal(单位分)
     */
    public static BigDecimal getBigDecimalToBigDecimalCent(BigDecimal bigDecimal) {
        if (Objects.isNull(bigDecimal)) {
            return null;
        }
        return bigDecimal.multiply(new BigDecimal(100));
    }

    /**
     * 订单详情数据转换
     */
    public static void transformOrderDetail(OrderDetail orderDetail) {
        orderDetail.setTotalPrice(getBigDecimalToBigDecimalCent(orderDetail.getTotalPrice()));
        orderDetail.setGoodsPrice(getBigDecimalToBigDecimalCent(orderDetail.getGoodsPrice()));
        orderDetail.setOriginOrderPrice(getBigDecimalToBigDecimalCent(orderDetail.getOriginOrderPrice()));
        orderDetail.setReducePrice(getBigDecimalToBigDecimalCent(orderDetail.getReducePrice()));
        orderDetail.setTransportFee(getBigDecimalToBigDecimalCent(orderDetail.getTransportFee()));
    }

    /**
     * 订单列表数据转换
     */
    public static List<OrderPageResult> transformOrderList(List<OrderPageResult> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.stream().forEach(orderPageResult -> {
                orderPageResult.setTotalPrice(getBigDecimalToBigDecimalCent(orderPageResult.getTotalPrice()));
                orderPageResult.setOriginOrderPrice(getBigDecimalToBigDecimalCent(orderPageResult.getOriginOrderPrice()));
                orderPageResult.setReducePrice(getBigDecimalToBigDecimalCent(orderPageResult.getReducePrice()));
                orderPageResult.setTransportFee(getBigDecimalToBigDecimalCent(orderPageResult.getTransportFee()));

                orderPageResult.getGoodsList().stream().forEach(orderItemDetail -> {
                    orderItemDetail.setPrice(getBigDecimalToBigDecimalCent(orderItemDetail.getPrice()));
                    orderItemDetail.setTotalPrice(getBigDecimalToBigDecimalCent(orderItemDetail.getTotalPrice()));
                    orderItemDetail.setUnitPrice(getBigDecimalToBigDecimalCent(orderItemDetail.getUnitPrice()));

                    orderItemDetail.getSkuList().stream().forEach(orderItemResult -> {
                        orderItemResult.setPrice(getBigDecimalToBigDecimalCent(orderItemResult.getPrice()));
                        orderItemResult.setTotalPrice(getBigDecimalToBigDecimalCent(orderItemResult.getTotalPrice()));
                    });
                });
            });
        }
        return list;
    }

    /**
     * 退款列表转换
     */
    public static List<OrderRefundMoneyPageResult> transformRefundList(List<OrderRefundMoneyPageResult> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.stream().forEach(orderRefundMoneyPageResult -> {
                orderRefundMoneyPageResult.setPrice(getBigDecimalToBigDecimalCent(orderRefundMoneyPageResult.getPrice()));
                orderRefundMoneyPageResult.setTotalPrice(getBigDecimalToBigDecimalCent(orderRefundMoneyPageResult.getTotalPrice()));
            });
        }
        return list;
    }
}
