/**
 * 商品中心错误码
 */
package cn.com.duiba.live.mall.api.dto;

/**
 * 此类描述的是： 项目错误码<br>
 * 错误码组成：AABBCCC
 * <ul>
 * AA：模块编号
 * <li>01：平台券商品模块</li>
 * <li>02：券码库模块(批次和券码)</li>
 * </ul>
 * <ul>
 * BB：错误类型
 * <li>01 - 应用级错误（前端参数错误）</li>
 * <li>02 - 业务级错误（service自身错误）</li>
 * <li>03 - 依赖级错误（service调用第三方服务错误）</li>
 * <li>04 - 交互级业务提醒（正常业务逻辑，非错误，需告知用户，如库存不足）</li>
 * </ul>
 * <ul>
 * <ul>
 * CCC:具体错误码 举例
 * <li>通用的成功状态码：0000000</li>
 * <li>通用的未知错误码：9999999</li>
 * </ul>
 */
public enum ErrorCode {

	/** 成功. */
	E0000000("000000", "成功"),
	/** 未知错误. */
	E9999999("9999999", "发生系统未知错误"),
	/** 更新失败 */
	E0102002("0102002", "更新失败"),
	/** 获取券码队列锁失败 */
	E0202004("0202004", "获取券码队列锁失败"),
	/** 批次下的券码已售罄 */
	E0202005("0202005", "批次下的券码已售罄"),
	/** 商品库存不足 */
	E0202006("0202006", "商品库存不足"),
	/** 不存在的类型 */
	E0202008("0202008", "不存在的类型"),
	/** 预分配库存不存在 */
	E0202009("0202009", "预分配库存不存在"),
	/** DUBBO获取券码id出错 */
	E0203001("0203001", "Dubbo获取券码ID出错"),
	/** DUBBO获取商品id出错 */
	E0203002("0203002", "Dubbo获取商品ID出错"),
	/** 类型不存在 */
	E0203013("0203013", "类型不存在"),
	/** DUBBO库存中心异常 */
	E0203003("0203003", "Dubbo库存中心异常"),
	/** 批次已存在 */
	E0404001("0404001", "批次已存在"),
	/** 系统繁忙！请稍后再试 */
	E0404002("0404002", "系统繁忙！请稍后再试"),
	/** 长度超出限制 */
	E0404003("0404003", "长度超出限制"),
	/** 参数错误 */
	E0404004("0404004", "参数错误"),
	/** 下载文件失败 */
	E0404005("0404005", "下载文件失败"),
	/** 批次日期不能为空 */
	E0404006("0404006", "批次日期不能为空"),
	/** 链接地址不能为空 */
	E0404007("0404007", "链接地址不能为空"),
	/** 券码不能为空 */
	E0404008("0404008", "券码不能为空"),
	/** 库存不能为空 */
	E0404009("0404009", "库存不能为空"),
	/** 获取批次切换锁失败 */
	E0404010("0404010", "获取批次切换锁失败"),
	/** 扣库存失败 */
	E0404011("0404011", "扣库存失败"),
	/** 取一张券失败 */
	E0404012("0404012", "取一张券失败"),
	/** 档位不存在 */
	E0404013("0404013", "档位不存在"),
	/** 开始日期必须大于当前日期 */
	E0404014("0404014", "开始日期必须大于当前日期"),
	/** 结束日期不能小于开始日期 */
	E0404015("0404015", "结束日期不能小于开始日期"),
	/** 商品已停用请重新新建商品 */
	E0404016("0404016", "商品已停用请重新新建商品"),
	/** 开始日期结束日期不能为空 */
	E0404017("0404017", "开始日期结束日期不能为空"),
	/** 内容不全，无法开启 */
	E0404018("0404018", "内容不全，无法开启"),
	/** 已过自动停用时间，不能启用 */
	E0404019("0404019", "已过自动停用时间，不能启用"),
	/** 已过自动停用时间，不能上架 */
	E0404020("0404020", "已过自动停用时间，不能上架"),
	/** 黑名单 */
	E0404021("0404021", "开发者黑名单"),
	/** 定向商品 */
	E0404022("0404022", "定向商品"),
	/** 活动专用商品 */
	E0404023("0404023", "活动专用商品"),
    /** 唯一键冲突 */
    E0404024("0404024", "唯一键冲突"),
	/** 不支持50个以上的appItem批量更新 */
	E0404025("0404025", "不支持50个以上的appItem批量更新"),
	/** 预分配商品 */
	E0404026("0404026", "预分配商品"),
	/** 下架商品 */
	E0404027("0404027", "兑吧商品已下架"),
	/** 重复扣库存失败 */
	E0404028("0404028", "重复扣库存失败"),
	/** 追加库存失败 */
	E0404029("0404029", "追加库存失败"),
	/** 系统不支持 */
	E0404030("0404030", "此方法已删除"),
	/** 不支持50个以上的appItem批量更新 */
	E0404031("E0404031", "不支持200个以上的appItem批量更新"),
    /**
     * 非卡密优惠券不能有密码
     **/
    E0404032("0404032", "非卡密优惠券不能有密码"),
	/** 批次不存在 */
	E0404033("0404033", "批次不存在"),

	E0404034("0404034", "参数错误: 查询数量不得超过50"),
	/** 同步sku失败**/
	E0404035("0404035", "同步sku失败"),
    ;

	/** 错误码. */
	private String code;

	/** 中文描述. */
	private String desc;

	/**
	 * 构造方法
	 *
	 * @param errorCode
	 *            错误码
	 * @param desc
	 *            描述信息
	 */
	private ErrorCode(String errorCode, String desc) {
		this.code = "GC-" + errorCode;
		this.desc = desc;
	}

	/**
	 * 获取错误码
	 *
	 * @return the code
	 */
	public String getErrorCode() {
		return code;
	}

	/**
	 * 获取错误信息
	 *
	 * @return the desc
	 */
	public String getDesc() {
		return desc;
	}

}
