package cn.com.duiba.live.mall.api.dto.order;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import cn.com.duiba.live.mall.api.util.BigDecimalSerializer;
import lombok.Data;

/**
 * 订单回款记录表
 * @author youqian mybatis generator 
 * 2020-04-08
 */
@Data
public class OrderMoneyBackDto implements Serializable {
    private static final long serialVersionUID = 15863255227116926L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 业务唯一ID
     */
    private Long orderMoneyBackId;

    /**
     * 商户ID
     */
    private Long merchantId;

    /**
     * 客户ID
     */
    private Long customerId;

    /**
     * 员工ID
     */
    private Long employeeId;

    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 收款方式,1-银行卡/2-支付包/3-微信/4-现金/5-其他方式
     */
    private Byte payWay;

    /**
     * 收款方式中文
     */
    private String payWayText;

    /**
     * 收款金额
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal moneyBack;

    /**
     * 收款时间
     */
    @JsonFormat(pattern = "yyyy年MM月dd日", timezone = "GMT+8")
    private Date eventTime;

    /**
     * 收款录入人UserId
     */
    private Long operateUserId;

    /**
     * 录入人名称
     */
    private String operateUserName;

    /**
     * 录入人头像
     */
    private String operateUserAvatarUrl;

    /**
     * 是否删除，0-未删除，其他-已删除
     */
    private Byte deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}