package cn.com.duiba.live.mall.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/4/9.
 */
@Getter
public enum TrueOrFalseEnum {
    TRUE(1,"true","正确"),
    FALSE(0,"false","错误")
    ;

    private final Integer code;

    private final String type;

    private final String desc;

    TrueOrFalseEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static TrueOrFalseEnum getByCode(Integer code) {
        return Stream.of(TrueOrFalseEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(FALSE);
    }

    public static TrueOrFalseEnum getByType(String type) {
        return Stream.of(TrueOrFalseEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(FALSE);
    }
}

