package cn.com.duiba.live.mall.api.params.goods;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class GoodsSkuRedisParam implements Serializable {

    /**
     * 库存数量
     */
    private Integer stockQuantity;

    /**
     * 已售数量
     */
    private Integer saledQuantity;

    /**
     * 计划数量
     */
    private Integer planQuantity;

    /**
     * 库存位
     */
    private Integer placeNum;

    /***
     * 销售价格
     */
    private BigDecimal salePrice;

    /***
     * 销售状态
     */
    private Byte deleted;

    /**
     * 返佣数量
     */
    private Byte returnType;

    /**
     * 返佣金额
     */
    private BigDecimal returnMoney;

    /**
     * 过期时间
     */
    private Date ExpireDate;

    /**
     * 商品规格
     */
    private String goodsSpecCode;
}
