package cn.com.duiba.live.mall.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.mall.api.dto.shopgoods.ShopGoodsDetail;
import cn.com.duiba.live.mall.api.dto.shopgoods.ShopGoodsDto;
import cn.com.duiba.live.mall.api.dto.shopgoods.ShopGoodsIntroductionDto;
import cn.com.duiba.live.mall.api.dto.shopgoods.ShopGoodsPicDto;
import cn.com.duiba.live.mall.api.dto.shopgoods.custom.GoodsWholeInfoV2;
import cn.com.duiba.live.mall.api.dto.shopgoods.custom.back.GoodsSkuTagBackDto;
import cn.com.duiba.live.mall.api.dto.shopgoods.custom.tag.GoodsTagAndGoodsCountDto;
import cn.com.duiba.live.mall.api.params.goods.AddGoodsParamV2;
import cn.com.duiba.live.mall.api.params.goods.GoodsListGetParamV2;
import cn.com.duiba.live.mall.api.params.goods.GoodsListParam;
import cn.com.duiba.live.mall.api.params.goods.LiveGoodsListParam;
import cn.com.duiba.live.mall.api.params.goods.OperateGoodsParam;
import cn.com.duiba.live.mall.api.params.goods.UpdateGoodsParam;
import cn.com.duiba.live.mall.api.params.goods.UpdateGoodsSaleStatus;
import cn.com.duiba.live.mall.api.response.GoodsDataResult;
import cn.com.duiba.live.mall.api.response.GoodsListResult;
import cn.com.duiba.live.mall.api.response.LiveGoodsLResult;

import java.util.Collection;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/21
 * @description
 */
@AdvancedFeignClient
public interface RemoteGoodsService {

    /**
     * 批量查询商品
     *
     * @param goodsIds goodsIds
     * @return List<ShopGoodsDto>
     */
    List<ShopGoodsDto> batchGet(Collection<Long> goodsIds);

    /**
     * 根据商品ID查商品
     *
     * @param goodsId goodsId
     * @return ShopGoodsDto
     */
    ShopGoodsDto selectByGoodsId(Long goodsId);

    /**
     * 查询商品详情
     *
     * @param goodsId goodsId
     * @return ShopGoodsDetail
     */
    ShopGoodsDetail selectOneDetail(Long goodsId);

    /**
     * 查询商品详情
     *
     * @param goodsIds goodsIds
     * @return List<ShopGoodsDetail>
     */
    List<ShopGoodsDetail> selectDetail(List<Long> goodsIds);

    /**
     * 查询商品介绍
     *
     * @param goodsId goodsId
     * @param goodsSkuId goodsSkuId
     * @return ShopGoodsIntroductionDto
     */
    ShopGoodsIntroductionDto selectOneIntro(long goodsId, long goodsSkuId);


    /**
     * 商品列表-后台管理
     */
    List<GoodsListResult> goodsList(GoodsListParam goodsListParam);

    /**
     * 商品列表-后台管理
     */
    Integer countGoodsList(GoodsListParam goodsListParam);

    /**
     * 标签列表
     */
    List<GoodsTagAndGoodsCountDto> selectByTagList(Long merchantId);

    /**
     * 批量查询商品的组图
     */
    List<ShopGoodsPicDto> selectShopGoodsPicList(Collection<Long> goodsIds);


    LiveGoodsLResult selectLiveGoodsList(LiveGoodsListParam liveGoodsListParam);

    /**
     * 添加商品
     * @param operateGoodsParam 商品列表请求参数
     */
    void addGoodsV2(AddGoodsParamV2 operateGoodsParam);

    /**
     * 更新商品
     * @param operateGoodsParam 商品列表请求参数
     */
    void updateGoodsV2(UpdateGoodsParam operateGoodsParam);

    /**
     * 更新商品上下架
     * @param goodsSaleStatus 商品列表请求参数
     */
    void updateSaleStatus(UpdateGoodsSaleStatus goodsSaleStatus);

    /**
     * 获取商品详情
     * @param shopGoodsId 商品id
     */
    GoodsWholeInfoV2 getGoodsInfoV2(Long shopGoodsId) throws BizException;

    /**
     * 获取商品列表
     * @param goodsListGetParam 商品列表请求参数
     * @return 商品vo分页数据
     */
    GoodsSkuTagBackDto listV2(GoodsListGetParamV2 goodsListGetParam);

    /**
     * 删除商品
     * @param operateGoodsParam 商品列表请求参数
     */
    void delGoods(OperateGoodsParam operateGoodsParam);

    /**
     * 商品列表
     */
    List<GoodsDataResult> liveGoodsList(List<Long> goodsIds);

    /**
     * 上传商品图片
     * @param url 地址
     * @param goodsId 商品ID
     * @param merchantId 商户ID
     */
    boolean uploadGoods(String url,Long goodsId,Long merchantId);
}
