package cn.com.duiba.live.mall.api.remoteservice.express;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.mall.api.dto.express.ReceiveAddressDto;

import java.util.List;

/**
 * @Author: lufeng
 * @Description:
 * @Date: Created in 2018/11/19
 */
@AdvancedFeignClient
public interface RemoteReceiveAddressService {

    /**
     * 通过consumerId查询收货信息列表
     * @param userId
     * @return
     */
    List<ReceiveAddressDto> listReceiveAddressByUserId(Long userId);

    /**
     * 通过consumerId查询默认收货信息
     * @param userId
     * @return
     */
    ReceiveAddressDto getDefaultReceiveAddressByUserId(Long userId);

    List<ReceiveAddressDto> getDefaultReceiveAddressByUserIds(List<Long> userIds);

    /**
     * 根据id查询地址
     * @param id
     * @return
     */
    ReceiveAddressDto getReceiveAddressById(Long id);


    /**
     * 根据id 删除地址
     * @param id  地址id
     * @return
     */
    void delAddressById(Long id);

    /**
     * 新增收货信息(最新)
     * @param receiveAddressDto
     * @return id
     */
    long insertAddressNew(ReceiveAddressDto receiveAddressDto);


    /**
     * 更新收货信息(最新)
     * @param receiveAddressDto
     * @return id
     */
    long updateAddressNew(ReceiveAddressDto receiveAddressDto);


}
