package cn.com.duiba.live.mall.api.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/4/8
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OrderMoneyBackPageRequest extends PageRequest implements Serializable {

    /**
     * 操作人（前端忽略）
     */
    private Long operatorUserId;

    /**
     * 操作商户（前端忽略）
     */
    private Long operatorMerchantId;

    @Min(1)
    @NotNull
    /**
     * 订单ID
     */
    private Long orderId;

}
