package cn.com.duiba.live.mall.api.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author: fss
 * @Date: 2021/8/10 14
 * @Description:
 */
@Data
@EqualsAndHashCode
public class OrderRefundApplyRequest implements Serializable {

    /**
     * 订单编号
     */
    @NotNull(message = "订单编号不能为空")
    @Min(value = 1, message = "订单编号必须大于0")
    private Long orderId;

    /**
     * 图片凭证
     */
    @NotNull(message = "图片凭证不能为空")
    private String imageUrl;

    /**
     * 退款备注
     */
    @NotNull(message = "退款备注不能为空")
    private String remark;

    /**
     * 退款类型：0:退货退款，1:仅退款
     */
    @NotNull(message = "退款类型不能为空")
    private Byte refundType;

    private Long liveUserId;
}
