package cn.com.duiba.live.mall.api.request;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
public class OrderRefundMoneyPageRequest extends PageRequest implements Serializable {

    /**
     * 订单归属商户ID
     * not null default = 0
     */
    private Long companyId;

    /**
     * 使用开始日期
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date beginDate;

    /**
     * 使用截止日期
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    /**
     * 退款状态 0-正常  2-审核处理中 4-审核通过 6-退款中 9-退款完成
     */
    private Byte refundStatus;

    /**
     * 审核操作人
     */
    private Long employeeId;

    /**
     * 订单预约人的名称 订单预约人的手机号码 订单使用人的手机号码
     */
    private String keyWords;

}
