package cn.com.duiba.live.mall.api.response;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class OrderRefundMoneyPageResult implements Serializable {

    /**
     * 申请退款ID
     * not null default = null
     */
    private Long refundId;

    /**
     * 订单项号
     * max length = 20
     * not null default =
     */
    private String orderNumber;

    /**
     * 订单项ID
     * not null default = 0
     */
    private Long orderItemId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 订单编号
     * not null default = 0
     */
    private Long orderId;

    /**
     * 客户ID
     * not null default = 0
     */
    private Long customerId;

    /**
     * 货号ID
     * not null default = 0
     */
    private Long goodsId;

    /**
     * 货号名称
     * max length = 50
     * not null default =
     */
    private String goodsName;

    /**
     * 货号规格ID
     * not null default = 0
     */
    private Long skuId;

    /**
     * 货号规格名称
     * max length = 50
     * not null default =
     */
    private String skuName;

    /**
     * 货号单价
     * not null default = 0.00
     */
    private BigDecimal price;

    /**
     * 货号商品个数
     * not null default = 0
     */
    private Integer num;

    /**
     * 总价
     * not null default = 0.00
     */
    private BigDecimal totalPrice;

    /**
     * 商品单位
     * max length = 10
     * not null default =
     */
    private String unit;


    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 退款状态 0-正常  2-审核处理中 4-审核通过 6-退款中 9-退款完成
     * not null default = 0
     */
    private Byte refundStatus;

    /**
     * 退款人ID
     * not null default = 0
     */
    private Long refundUserId;

    /**
     * 审核人员工ID
     * not null default = 0
     */
    private Long checkEmployeeId;

    /**
     * 审核时间
     */
    private Date checkTime;

    /**
     * 付款人员工ID
     * not null default = 0
     */
    private Long payEmployeeId;

    /**
     * 付款时间
     */
    private Date payTime;

    /**
     * 申请理由
     * max length = 200
     */
    private String applyReason;

    /**
     * 审核备注
     * max length = 200
     */
    private String checkMemo;

    /**
     * 取消状态 0-正常 1-拒绝
     * not null default = 0
     */
    private Byte cancelStatus;

    /**
     * 客户姓名
     */
    private String customerName;
    /**
     * 客户电话
     */
    private String customerMobile;
    /**
     * 审核人姓名
     */
    private String checkEmployeeName;
    /**
     * 付款人姓名
     */
    private String payEmployeeName;
}
