package cn.com.duiba.live.mall.api.util;

import cn.com.duiba.wolf.utils.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author xiachenhang
 */
@Slf4j
public class DateUtil extends DateUtils {
    /**
     * 显示时间间隔
     * 大于一年的 展示 ：年月日
     * 同年：
     * 日期间隔超过1天： 展示 ：月日
     *
     * 同一天：
     * 时间间隔大于1小时的，显示  x小时前
     * 时间间隔小于60分钟的，显示 X分钟前
     * 时间间隔小于60秒的，    显示 刚刚
     * @param longTime
     * @return
     */
    public static String getInterval(Long longTime){
        Long long_by_13 = 1000000000000L;
        Long long_by_10 = 1000000000L;
        if (longTime / long_by_13 < 1) {
            if (longTime / long_by_10 >= 1) {
                longTime = Long.parseLong(longTime + "000");
            }
        }
        Timestamp time = new Timestamp(longTime);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long dayConver = 1000 * 60 * 60 * 24;
        long hourConver = 1000 * 60 * 60;
        long minConver = 1000 * 60;
        long timeConver = now.getTime() - time.getTime();
        long tempConver;
        if ((timeConver / dayConver) < 2) {
            SimpleDateFormat format = new SimpleDateFormat("HH:mm");
            tempConver = timeConver / dayConver;
            if (tempConver <= 2 && tempConver >= 1) {
                return "昨天" +  format.format(time);
            } else {
                tempConver = (timeConver / hourConver);
                if (tempConver >= 1) {
                    return tempConver + "小时前";
                } else {
                    tempConver = (timeConver / minConver);
                    if (tempConver >= 1) {
                        return tempConver + "分钟前";
                    } else {
                        return "刚刚";
                    }
                }
            }
        } else if((timeConver / dayConver)< 365 ){
            SimpleDateFormat format = new SimpleDateFormat("MM月dd日 HH:mm");
            return format.format(time);
        } else{
            SimpleDateFormat format = new SimpleDateFormat("yyyy年MM月dd日");
            return format.format(time);
        }
    }

    /**
     * 时间展示
     * @param longTime 时间
     * @return
     */
    public static String getIntervalV2(long longTime){
        Date todayFirstTime = getDayDate(new Date());
        Date yesterdayFirstTime = changeByDay(new Date(), -1);
        Date t = new Date(longTime);
        //今天
        if(t.compareTo(todayFirstTime) >= 1){
            long interval = System.currentTimeMillis() - longTime;
            long hour = 1000 * 60 * 60;
            long min = 1000 * 60;
            long hourInterval = interval/hour;
            if (hourInterval >= 1) {
                return hourInterval + "小时前";
            }
            long minInterval = interval/min;
            if (minInterval >= 1) {
                return minInterval + "分钟前";
            }
            return "刚刚";
        }
        //昨天
        if(t.compareTo(yesterdayFirstTime) >= 1){
            return "昨天" +  getMinuteOnlyStr(t);
        }
        //昨天前
        SimpleDateFormat format = new SimpleDateFormat("MM月dd日 HH:mm");
        return format.format(longTime);
    }

    /**
     * 间隔时间
     * @param time 时间
     * @return
     */
    public static String secToTime(String time) {
        if(StringUtils.isEmpty(time)){
            return 0+"秒";
        }
        Integer secTime = Integer.parseInt(time);
        String timeStr;
        int hour,minute,second;
        if (secTime <= 0)
            return 0+"秒";
        else {
            minute = secTime / 60;
            if (minute < 60) {
                second = secTime % 60;
                timeStr = (minute == 0 ?"":(minute + "分钟")) + (second == 0?"":(second + "秒"));
            } else {
                hour = minute / 60;
                if (hour > 99)
                    return 99 + "时";
                minute = minute % 60;
                second = secTime - hour * 3600 - minute * 60;
                timeStr = (hour == 0?"":hour + "小时") + (minute == 0?"":(minute + "分钟")) + (second == 0?"":(second + "秒"));
            }
        }
        return timeStr;
    }

    public static String secToTime1(String time) {
        if(StringUtils.isEmpty(time)){
            return 0+"秒";
        }
        Integer secTime = Integer.parseInt(time);
        String timeStr;
        int hour,minute,second;
        if (secTime <= 0)
            return 0+"秒";
        else {
            minute = secTime / 60;
            if (minute < 60) {
                second = secTime % 60;
                timeStr = (minute == 0 ?"":(minute + "分钟")) + (second == 0?"":(second + "秒"));
            } else {
                hour = minute / 60;
                if (hour > 99)
                    return 99 + "时";
                minute = minute % 60;
                timeStr = hour + "小时" + (minute == 0?"":(minute + "分钟"));
            }
        }
        return timeStr;
    }


    /**
     * 增加或减少分钟
     *
     * @param date
     * @param min 负数为减少，正数为增加
     * @return
     */
    public static Date changeByMin(Date date, int min) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(Calendar.MINUTE, min);
        return cal.getTime();
    }

    /**
     * 是否早上9点到晚上10点
     * @return
     */
    public static boolean isTimeRange(){
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        Date now,begin,end;
        try {
            now = df.parse(df.format(new Date()));
            begin = df.parse("9:00");
            end = df.parse("22:00");
        } catch (ParseException e) {
            log.error("时间格式转义失败:[{}]",e);
            return false;
        }
        Calendar nowTime = Calendar.getInstance();
        nowTime.setTime(now);
        Calendar beginTime = Calendar.getInstance();
        beginTime.setTime(begin);
        Calendar endTime = Calendar.getInstance();
        endTime.setTime(end);
        if (nowTime.before(endTime) && nowTime.after(beginTime)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * 是否当天
     * @return
     */
    public static boolean isCurrentRange(Date time){
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date now;
        try {
            now = df.parse(df.format(new Date()));
            time = df.parse(df.format(time));
        } catch (ParseException e) {
            log.error("时间格式转义失败:[{}]",e);
            return false;
        }
        Calendar nowTime = Calendar.getInstance();
        nowTime.setTime(now);
        Calendar currentTime = Calendar.getInstance();
        currentTime.setTime(time);
        if (nowTime.equals(currentTime)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * 获取相前时间与传入时间的相差几天
     * @param date
     * @return
     */
    public static long getDifferDayNew(Date date) {
        return getDifferDayNew(date,new Date());
    }

    /**
     * 获取相前时间与传入时间的相差几分钟
     * @param date
     * @return
     */
    public static long getDifferMinuteNew(Date date) {
        return getDifferMinuteNew(date,new Date());
    }

    public static long getDifferMinuteNew(Date d1,Date d2) {
        return Math.abs(d1.getTime() - d2.getTime()) / (1000 * 60);
    }

    /**
     * 获取相前时间与传入时间的相差几天
     * @param d1
     * @param d2
     * @return
     */
    public static long getDifferDayNew(Date d1,Date d2) {
        return Math.abs(d1.getTime() - d2.getTime()) / (1000 * 24 * 60 * 60);
    }

    /**
     * 获取某天的零点及最后一秒
     * @param time
     * @return
     */
    public static Map<String,Date> getDate(Date time) {
        Map map = new HashMap(2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        //  下面的这个时间为当天时间的   零点
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        Date start = calendar.getTime();
        map.put("startTime",start);
        //  下面的这个时间为当天的最后一秒
        calendar.add(Calendar.DAY_OF_MONTH, 1);
        // 一天后的时间
        calendar.add(Calendar.SECOND, -1);
        Date end = calendar.getTime();
        map.put("endTime",end);
        return map;
    }

    /**
     * 转换时间格式 X月X日 HH:mm
     *
     * @param date 时间
     * @return
     */
    public static String getDateText(Date date) {
        DateFormat df = new SimpleDateFormat("MM月dd日 HH:mm");
        return df.format(date);
    }
    /**
     * 转换时间格式 X月X日 HH:mm
     *
     * @param date 时间
     * @return
     */
    public static String getDateText1(Date date) {
        DateFormat df = new SimpleDateFormat("MM-dd HH:mm");
        return df.format(date);
    }

    public static LocalDate toLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);

        return localDateTime.toLocalDate();
    }

    /**
     * 判断当天是否本月第一天
     */
    public static boolean isMonthFirst(){
        String mf = getDayStr(getMonthFirstDayTimeInMillis());
        String n = getDayStr(new Date());
        return Objects.equals(mf,n);
    }

    /**
     * 获取当前日期是星期几<br>
     *
     * @param dt
     * @return 当前日期是星期几
     */
    public static String getWeekOfDate(Date dt) {
        String[] weekDays = {"星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int w = cal.get(Calendar.DAY_OF_WEEK) - 1;
        if (w < 0)
            w = 0;
        return weekDays[w];
    }

    /**
     * 直播列表带开播时长
     * 星期X XX:XX
     */
    public static String getLiveFormat(Date date){
        String week = getWeekOfDate(date);
        String time = getMinuteOnlyStr(date);
        return week + " " +time;
    }


    /**
     * yyyyMMddHHmmss转为日期
     */
    public static Date getDateByDateString(String datetime) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        LocalDateTime localDateTime = LocalDateTime.parse(datetime, dtf);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    /**
     * 获取相前时间与传入时间的相差几个自然天
     * @param d1
     * @param d2
     * @return
     */
    public static long getDifferDayNum(Date d1,Date d2) {
        //程序启动时
        long start = d1.getTime();

        long end = d2.getTime();
        long days = (end - start) / (1000 * 60 * 60 * 24);

        long runningDays = days + 1;

//        long probableEndMillis = start + (1000 * 60 * 60 * 24) * days;
//
//        if(new Date(probableEndMillis).getDay() != new Date(end).getDay())
//        {
//         　　runningDays++;
//        }

        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");//如2016-08-10 20:40
        String fromDate = simpleFormat.format(d1);
        String toDate = simpleFormat.format(d2);
        if(!fromDate.equals(toDate)){
            runningDays++;
        }

        return runningDays;
    }

    public static long getDifferDayNum2(Date d1,Date d2) {
        //程序启动时
        long start = d1.getTime();

        long end = d2.getTime();

//        long probableEndMillis = start + (1000 * 60 * 60 * 24) * days;
//
//        if(new Date(probableEndMillis).getDay() != new Date(end).getDay())
//        {
//         　　runningDays++;
//        }

        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyyMMdd");//如2016-08-10 20:40
        String fromDate = simpleFormat.format(d1);
        String toDate = simpleFormat.format(d2);

        return (Long.valueOf(toDate) - Long.valueOf(fromDate));
    }

}
