/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.mall.api.response;

import cn.com.duiba.live.mall.api.request.PageRequest;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class PageResult<T>
implements Serializable {
    private static final long serialVersionUID = 3500044282124584159L;
    private List<T> list;
    private Integer pageNo;
    private Integer pageSize;
    private Boolean hasNext;
    private Long total = 0L;
    private Integer totalPageNo = 0;

    public static <T> PageResult<T> create(List<T> data, Integer pageNo, Integer pageSize, Long total) {
        PageResult<T> pageResult = new PageResult<T>();
        pageResult.setList(data);
        pageResult.setPageNo(pageNo);
        pageResult.setPageSize(pageSize);
        pageResult.setTotal(total);
        if (CollectionUtils.isEmpty(data)) {
            pageResult.setHasNext(false);
        } else if (pageSize > data.size()) {
            pageResult.setHasNext(false);
        } else {
            pageResult.setHasNext(true);
        }
        long totalPageNo = total % (long)pageSize.intValue() == 0L ? total / (long)pageSize.intValue() : total / (long)pageSize.intValue() + 1L;
        pageResult.setTotalPageNo((int)totalPageNo);
        return pageResult;
    }

    public static <T> PageResult<T> create(List<T> data, PageRequest pageRequest, Long total) {
        return PageResult.create(data, pageRequest.getPageNo(), pageRequest.getPageSize(), total);
    }

    public List<T> getList() {
        return this.list;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Boolean getHasNext() {
        return this.hasNext;
    }

    public Long getTotal() {
        return this.total;
    }

    public Integer getTotalPageNo() {
        return this.totalPageNo;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setHasNext(Boolean hasNext) {
        this.hasNext = hasNext;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public void setTotalPageNo(Integer totalPageNo) {
        this.totalPageNo = totalPageNo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResult)) {
            return false;
        }
        PageResult other = (PageResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<T> this$list = this.getList();
        List<T> other$list = other.getList();
        if (this$list == null ? other$list != null : !((Object)this$list).equals(other$list)) {
            return false;
        }
        Integer this$pageNo = this.getPageNo();
        Integer other$pageNo = other.getPageNo();
        if (this$pageNo == null ? other$pageNo != null : !((Object)this$pageNo).equals(other$pageNo)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Boolean this$hasNext = this.getHasNext();
        Boolean other$hasNext = other.getHasNext();
        if (this$hasNext == null ? other$hasNext != null : !((Object)this$hasNext).equals(other$hasNext)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        Integer this$totalPageNo = this.getTotalPageNo();
        Integer other$totalPageNo = other.getTotalPageNo();
        return !(this$totalPageNo == null ? other$totalPageNo != null : !((Object)this$totalPageNo).equals(other$totalPageNo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<T> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        Integer $pageNo = this.getPageNo();
        result = result * 59 + ($pageNo == null ? 43 : ((Object)$pageNo).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Boolean $hasNext = this.getHasNext();
        result = result * 59 + ($hasNext == null ? 43 : ((Object)$hasNext).hashCode());
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        Integer $totalPageNo = this.getTotalPageNo();
        result = result * 59 + ($totalPageNo == null ? 43 : ((Object)$totalPageNo).hashCode());
        return result;
    }

    public String toString() {
        return "PageResult(list=" + this.getList() + ", pageNo=" + this.getPageNo() + ", pageSize=" + this.getPageSize() + ", hasNext=" + this.getHasNext() + ", total=" + this.getTotal() + ", totalPageNo=" + this.getTotalPageNo() + ")";
    }
}

