package cn.com.duiba.supplier.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.SubAccountRecordDto;

import java.util.List;

/**
 * 分账相关流水接口
 *
 * @Author xujing
 * @Date 2022/1/11 9:58 上午
 */
@AdvancedFeignClient
public interface RemoteSubAccountRecordService {

    /**
     * 批量插入
     *
     * @param list
     * @return
     */
    int batchInsert(List<SubAccountRecordDto> list);

    /**
     * 批量更新
     *
     * @param list
     * @return
     */
    int updateBatch(List<SubAccountRecordDto> list);

    /**
     * 根据订单号查询订单的分账信息
     * @param orderNo
     * @return
     */
    List<SubAccountRecordDto> listByOrderNo(String orderNo);

    /**
     * 根据订单号查询订单的分账信息
     * @param orderNo
     * @param status
     * @see cn.com.duiba.supplier.center.api.enums.SubAccountRecordStatusEnum
     * @return
     */
    int updateStatusByOrderNo(String orderNo,Integer status);
}
