package cn.com.duiba.supplier.center.api.dto.addr;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 供应商商品地域限制
 *
 * @TableName tb_addr_limit
 */
@Data
public class AddrLimitDto implements Serializable {

    private static final long serialVersionUID = -7532592376512017626L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 兑吧商品ID,来源item.id
     */
    private Long itemId;

    /**
     * 供应商商品ID
     */
    private Long supplierGoodsId;

    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 省代码
     */
    private String proCode;

    /**
     * 市代码,all代表全部
     */
    private String cityCode;

    /**
     * 类型：黑/白名单
     * {@link cn.com.duiba.supplier.center.api.enums.addr.AddrLimitTypeEnum}
     */
    private Integer type;

    /**
     * json字段
     */
    private String json;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

}