package cn.com.duiba.supplier.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.*;
import cn.com.duiba.supplier.center.api.params.DuibaLiveSupplierBftUploadDataParam;

/**
 * @date:2022/1/7 11:38
 * @author:zhaozhanghai
 * @Description: 供应商 宝付通账户信息
 */
@AdvancedFeignClient
public interface RemoteDuibaLiveSupplierBftService {


    DuibaLiveSupplierBftDto getById(Long id);

    /**
     * 供应商id 获取 bft账户信息
     * @param supplierId
     * @return
     */
    DuibaLiveSupplierBftDto getBySupplierId(Long supplierId);

    Long save(DuibaLiveSupplierBftDto duibaLiveSupplierBftDto);

    int updateById(DuibaLiveSupplierBftDto duibaLiveSupplierBftDto);

    /**
     * 宝付通开户
     * @param duibaLiveSupplierBftDto
     * @return
     */
    Boolean openBft(DuibaLiveSupplierBftDto duibaLiveSupplierBftDto) throws Exception;

    /**
     * 宝付开户 第二部 上传资料
     * @param param
     * @return
     * @throws Exception
     */
    Boolean uploadData(DuibaLiveSupplierBftUploadDataParam param) throws Exception;

    /**
     * 宝付通只有在用户小额鉴权成功时通知 然后调用这个接口
     * 供应商开户置为成功
     * @param supplierId
     * @return
     */
    Boolean openAccountSuccess(Long supplierId) throws BizException;




}
