package cn.com.duiba.supplier.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.DuibaLiveSupplierOrderDto;

/**
 * 兑吧直播供应商订单remote
 * @author zhanghuifeng
 * @date 2022/1/8 10:33
 */
@AdvancedFeignClient
public interface RemoteDuibaLiveSupplierOrderService {

    /**
     * 插入订单
     * @param dto 订单属性
     * @return 兑吧直播供应商订单ID （为空时则插入失败）
     */
    Long insert(DuibaLiveSupplierOrderDto dto);

    /**
     * 根据兑吧主订单ID更新订单属性
     * @param dto 订单属性（duibaOrdersId不能为空）
     * @return 更新结果
     */
    Boolean updateByDuibaOrdersId(DuibaLiveSupplierOrderDto dto);

}
