package cn.com.duiba.supplier.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.DuibaLiveSupplierGoodsDto;
import cn.com.duiba.supplier.center.api.dto.ItemSupplierDto;
import java.util.List;

/**
 * @Author: fss
 * @Date: 2022/1/7 15
 * @Description: 供应商商品服务
 */
@AdvancedFeignClient
public interface RemoteDuibaLiveSupplierGoodsService {
    /**
     * 获取兑吧item商品list的供应商端数据信息
     *
     * @param itemIds
     */
    List<ItemSupplierDto> getItemExtraSupplierList(List<Long> itemIds);

    /**
     * 获取启用的duibaItemIds
     * @param supplierId 供应商id
     * @return  duibaItemIds
     */
    List<Long> listIsEnableDuibaItemIdsBySupplierId(Long supplierId);

    /**
     * 获取兑吧单个item商品的供应商端数据信息
     * @param itemId
     * @return
     */
    DuibaLiveSupplierGoodsDto getByItemId(Long itemId);
}
