package cn.com.duiba.supplier.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author: fss
 * @Date: 2022/1/10 11
 * @Description:
 */
@Data
public class DuibaLiveSupplierGoodsSkuDto implements Serializable {

    private static final long serialVersionUID = -1522852604909857675L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 供应商商品ID
     */
    private Long supplierGoodsId;

    /**
     * 供应商商品ID
     */
    private Long duibaSkuId;

    /**
     * 划线价，对应tb_supplier_goods表market_price
     */
    private Long facePrice;

    /**
     * 建议零售价
     */
    private Long suggestMarketPrice;

    /**
     * 供货价，对应tb_supplier_goods表actual_price
     */
    private Long salePrice;

    /**
     * 库存id
     */
    private Long stockId;

    /**
     * 属性json串，多属性之间用;分隔，属性值与key之间用:分隔，如：属性ID:系统属性值:开发者自定义属性
     */
    private String attributeJson;

    /**
     * sku子图(预留)
     */
    private String imgUrl;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 商家编码
     */
    private String merchantCoding;

    /**
     * 是否删除
     */
    private Integer deleted;

    /**
     * 是否可售，0：否；1，是
     */
    private Integer onsale;

    /**
     * 成本价
     */
    private Long costPrice;
}
