package cn.com.duiba.supplier.center.api.dto.sku;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Desc SKU规格属性链，树形结构
 * @Author xuwei
 * @Date 2018/11/6
 */
@Data
public class SkuAttributeNode<T extends Serializable> implements Serializable {

    private static final long serialVersionUID = 4889249887035984312L;

    /**
     * 属性id
     */
    private String id;

    /**
     * 图片地址
     */
    private String imgUrl;

    /**
     * 规格id, 实际是spec id
     */
    private String specId;

    /**
     * 销售信息（T可能为SKU信息、SKU积分换购信息）
     */
    private T skuInfo;

    /**
     * 子属性列表
     */
    private List<SkuAttributeNode<T>> children;

    /**
     * 销售信息
     */
    @Data
    public static class SkuInfo implements Serializable {

        private static final long serialVersionUID = -9491789203686703L;

        /**
         * skuId，更新时使用
         */
        private String id;

        /**
         * 展示价格
         */
        private String facePrice;

        /**
         * 兑换价格
         */
        private String salePrice;

        /**
         * 成本价
         */
        private String costPrice;

        /**
         * 商家编码
         */
        private String merchantCoding;

        /**
         * 图片链接（暂时取的是第一个规格属性配置的imgUrl）
         */
        private String imgUrl;

        /**
         * 库存id
         */
        private String stockId;

        /**
         * 剩余库存
         */
        private Integer remaining;

        /**
         * 前一次库存
         */
        private Integer preRemaining;
    }

    /**
     * 管理后台销售信息
     */
    @Data
    public static class SkuSupplyInfo extends SkuInfo {
        private static final long serialVersionUID = 5496247665871114160L;

        /**
         * 建议市场价(仅供管理后台用)
         */
        private String suggestMarketPrice;

        //卡券库id
        private String cardLibraryId;
    }

}
