package cn.com.duiba.live.supplier.center.api.dto;

import cn.com.duiba.live.supplier.center.api.enums.SubAccountRecordStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 分账流水表
 * @Author xujing
 * @Date 2022/1/11 9:43 上午
 */
@Data
public class SubAccountRecordDto implements Serializable {

    private static final long serialVersionUID = -8256742080650098198L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 分账类型 0代表兑吧 1代表供应商
    */
    private Integer subType;

    /**
    * 供应商id
    */
    private Long supplierId;

    /**
    * 兑吧订单号
    */
    private String orderNo;

    /**
    * 兑吧商品id
    */
    private Long itemId;

    /**
    * 供应商商品id
    */
    private Long supplierItemId;

    /**
    * 用户支付金额
    */
    private Long payAmount;

    /**
    * 供货价
    */
    private Long supplyPrice;

    /**
    * 分账金额 >0代表入账 <0代表出账
    */
    private Long incomeAmount;

    /**
     * @see SubAccountRecordStatusEnum
    * 0创建中 1待分账 2已部分退款 3分账完成 4已全部退款
    */
    private Integer recordStatus;

    /**
    * 分账子订单号
    */
    private String subOutOrderNo;

    /**
     * 分账订单号
     */
    private String outOrderNo;

    /**
     * 是否跨境 1跨境 0非跨境
     */
    private Integer crossBorder;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;
}