package cn.com.duiba.live.supplier.center.api.remoteservice.addr;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.supplier.center.api.dto.addr.AddrLimitDto;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2022/01/10 14:03
 * @description 地域限制相关 RPC
 */
@AdvancedFeignClient
public interface RemoteDuibaLiveAddrLimitService {

    /**
     * 批量添加
     *
     * @param list 地域限制列表
     * @return 添加条数
     */
    int batchInsert(List<AddrLimitDto> list);

    /**
     * 删除商品地域限制
     *
     * @param goodsId 商品类型
     * @return 删除条数
     */
    int deleteAddrLimit(Long goodsId);

    /**
     * 根据商品Id查询地域限制列表
     *
     * @param goodsId 商品Id
     * @return 地域限制列表
     */
    List<AddrLimitDto> listByGoodsId(Long goodsId);

}
