package cn.com.duiba.live.supplier.center.api.remoteservice.goods.extra;

import cn.com.duiba.api.bo.KeyValueDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 商品新拓展信息接口
 * 增加app item的接口请加appItem
 * Created by hww on 2018/4/25 下午8:20.
 */
@AdvancedFeignClient
public interface RemoteDuibaSupplierGoodsExtraService {

    /**
     * 批量insert Item extra
     *
     * @param goodsId 商品Id
     * @return 执行结果
     */
    int updateOrInsertBatchApi(Long goodsId, List<KeyValueDto> kvs);

    /**
     * 根据商品Id返回拓展信息列表
     *
     * @param goodsId 商品Id
     * @return 拓展信息列表
     */
    List<KeyValueDto> listByGoodsId(Long goodsId);

}
