package cn.com.duiba.live.supplier.center.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 兑吧直播供应商审批审核状态枚举
 * @author zhanghuifeng
 * @date 2022/1/8 14:50
 */
@Getter
@AllArgsConstructor
public enum DuibaLiveSupplierGoodsAuditStateEnum {

    WAIT_AUDIT(0,"待审核"),
    PASS_AUDIT(1,"审核通过"),
    REJECT_AUDIT(2,"审核拒绝"),
    CANCEL_AUDIT(3,"取消申请"),
    ;
    private final Integer state;

    private final String desc;

    public static DuibaLiveSupplierGoodsAuditStateEnum fromStatus(String status) {
        for (DuibaLiveSupplierGoodsAuditStateEnum it : DuibaLiveSupplierGoodsAuditStateEnum.values()) {
            if (status.equals(it.getState())) {
                return it;
            }
        }
        return null;
    }
}
