package cn.com.duiba.live.supplier.center.api.params;

import lombok.Data;

import java.io.Serializable;

/**
 * @date:2022/1/12 17:32
 * @author:zhaozhanghai
 * @Description: 宝付通上传资料
 */
@Data
public class DuibaLiveSupplierBftUploadDataParam  implements Serializable {
    private static final long serialVersionUID = -6635373002046356295L;

    /**
     * supplierId
     */
    private Long supplierId;
    /**
     * 营业执照图片
     */
    private String base64ImgForLicense;

    /**
     * 法人身份证头像图片
     */
    private String base64ImgFrontForCorporate;

    /**
     * 法人身份证国徽图片
     */
    private String base64ImgBackForCorporate;

    /**
     * 代理人身份证头像图片 申请开户时proposer为0时，必填。代理人申请开户时上传
     */
    private String base64ImgFrontForAgent;

    /**
     * 代理人身份证国徽图片 申请开户时proposer为0时，必填。代理人申请开户时上传
     */
    private String base64ImgBackForAgent;

    /**
     * 代理人委托书 代理人申请开户时上传
     */
    private String base64ImgForAgentPaper;
}
