package cn.com.duiba.live.supplier.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.supplier.center.api.dto.DuibaLiveSupplierGoodsDto;
import cn.com.duiba.live.supplier.center.api.dto.ItemSupplierDto;
import java.util.List;

/**
 * @Author: fss
 * @Date: 2022/1/7 15
 * @Description: 供应商商品服务
 */
@AdvancedFeignClient
public interface RemoteDuibaLiveSupplierGoodsService {
    /**
     * 获取兑吧item商品list的供应商端数据信息
     *
     * @param itemIds
     */
    List<ItemSupplierDto> getItemExtraSupplierList(List<Long> itemIds);

    /**
     * 获取启用的duibaItemIds
     * @param supplierId 供应商id
     * @return  duibaItemIds
     */
    List<Long> listIsEnableDuibaItemIdsBySupplierId(Long supplierId);

    /**
     * 获取兑吧单个item商品的供应商端数据信息
     * @param itemId
     * @return
     */
    DuibaLiveSupplierGoodsDto getByItemId(Long itemId);

    /**
     * 获取供应商商品数据信息通过供应商商品id
     * @param itemId
     * @return
     */
    DuibaLiveSupplierGoodsDto getBySupplierItemId(Long itemId);

    /**
     * 获取失效状态商品list
     * @return
     */
    List<Long> getInvalidItemList();

    /**
     * RightLike查询获取商品id
     * @param itemName 商品名
     * @param itemMemo 商品备注
     * @return
     */
//    List<Long> listDuibaItemIdsByRightLikeNameAndMemo(String itemName,String itemMemo);
}
