package cn.com.duiba.live.supplier.center.api.dto;

import cn.com.duiba.live.supplier.center.api.enums.supplier.DuibaLiveSupplierStateEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @date:2022/1/7 11:40
 * @author:zhaozhanghai
 * @Description:
 */
@Data
public class DuibaLiveSupplierDto implements Serializable {


    private static final long serialVersionUID = 73861846586514878L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 供应商名
     */
    private String supplierName;

    /**
     * 供应商简称
     */
    private String supplierShortName;

    /**
     * 联系人
     */
    private String contactName;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 经营类目goodsType 1-实物 2-卡券 3-虚拟商品  [{type:1,itemClassifyId:[{id:1,name:食品酒水}]},{type:2}]
     */
    private String businessCategory;

    /**
     * 供应商状态:0关闭1开启
     * {@link DuibaLiveSupplierStateEnum}
     */
    private Integer supplierState;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 登录名
     */
    private String loginAccount;

    /**
     * 登陆密码
     */
    private String loginPassword;

    /**
     * 是否包含跨境商品 0-不包含 1-包含
     */
    private Integer isCross;


    /**
     * 供应商类型 0-自营 1-pop
     */
    private Integer supplierType;

    /**
     * 是否缴纳保证金 0-未缴纳 1-已缴纳
     */
    private Integer isPayBond;

    /**
     * 供应商资质图片url  http://1.jpg,http://2.jpg
     */
    private String supplierQualifications;

    /**
     * 类目资质图片url  http://1.jpg,http://2.jpg
     */
    private String categoryQualifications;

    /**
     * 是否开户宝付通 0-没开户 1-已开户
     */
    private Integer isOpenBft;
}
