package cn.com.duiba.live.supplier.center.api.dto.goods.sync;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author zhuenhui
 * @date 2022/01/11 19:36
 * @description 商品 - 实物详情Dto
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class SupplierGoodsObjectDto extends SupplierGoodsBaseDto {

    private static final long serialVersionUID = 8409585215266863289L;

    /**
     * 经营类目（目前只有实物有）
     * 1-食品酒水 2-美妆护肤 3-数码电器 4-宠物用品 5-百货家清 6-母婴
     */
    private Integer itemClassifyId;

    /**
     * 是否是跨境商品, 1-是 0-否, 默认为0
     */
    private Integer isCross = 0;
}
