package cn.com.duiba.live.supplier.center.api.dto.sku;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName: AttributeLibraryDto
 * @Description: 商品属性库（属性名）
 * @author: fxr
 * @date: 2018/6/11 下午4:05
 * @version: V1.0.0
 */
@Data
public class AttributeLibraryDto implements Serializable {
    private static final long serialVersionUID = -6114728293129685864L;
    /**
     * 唯一id
     */
    private Long id;

    /**
     * 属性名称
     */
    private String attributeName;

    /**
     * 属性类型 1：实物 2：优惠券 3：卡密 4：虚拟
     */
    private Integer attributeType;

    /**
     * 属性值类型 1：单选 2：多选 3：文本
     */
    private Integer attributeValueType;

    /**
     * 逻辑删除标识
     */
    private Integer isDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 应用id
     */
    private Long appId;

}
