package cn.com.duiba.live.supplier.center.api.dto.sku;

import lombok.Data;

import java.io.Serializable;

/**
 * 规格信息
 *
 * @author xuwei
 */
@Data
public class GoodsSkuInfo implements Serializable {

    private static final long serialVersionUID = -680699258309415947L;

    /**
     * skuId，更新时使用
     */
    private String id;

    /**
     * 展示价格
     */
    private String facePrice;

    /**
     * 兑换价格
     */
    private String salePrice;

    /**
     * 成本价
     */
    private String costPrice;

    /**
     * 商家编码
     */
    private String merchantCoding;

    /**
     * 图片链接（暂时取的是第一个规格属性配置的imgUrl）
     */
    private String imgUrl;

    /**
     * 库存id
     */
    private String stockId;

    /**
     * 剩余库存
     */
    private Integer remaining;

    /**
     * 前一次库存
     */
    private Integer preRemaining;

    /**
     * 建议市场价
     */
    private String suggestMarketPrice;

    /**
     * 卡券库id
     */
    private String cardLibraryId;
}
