package cn.com.duiba.live.supplier.center.api.enums;

/**
 * @author lizhi
 * @date 2020/3/30 2:34 PM
 */
public enum RedisKeyFactory {

    KC001("审核状态变更锁"),
    KC002("审核单数据同步锁"),
    ;

    private static final String SPACE = "DBLSCTC";
    private static final String SEPARATOR = "_";

    String desc;

    RedisKeyFactory(String desc) {
        this.desc = desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    public String lockKey(Object... args) {
        return join(args) + ":lock";
    }

    @Override
    public String toString(){
        return SPACE +SEPARATOR+ this.name();
    }
}
