package cn.com.duiba.live.supplier.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.supplier.center.api.base.PageResp;
import cn.com.duiba.live.supplier.center.api.dto.DuibaLiveSupplierGoodsAuditDto;
import cn.com.duiba.live.supplier.center.api.dto.mng.SupplierGoodsMngSyncDto;
import cn.com.duiba.live.supplier.center.api.params.DuibaLiveSupplierGoodsAuditPageParam;

import java.util.List;
import java.util.Map;

/**
 * @Author: fss
 * @Date: 2022/1/8 18
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteSupplierGoodsAuditService {

    Integer insert(DuibaLiveSupplierGoodsAuditDto record);

    Integer insertSelective(DuibaLiveSupplierGoodsAuditDto record);

    DuibaLiveSupplierGoodsAuditDto selectByPrimaryKey(Long id);

    DuibaLiveSupplierGoodsAuditDto selectCurrentAuditByDuibaItemId(Long itemId);

    DuibaLiveSupplierGoodsAuditDto selectWaitAuditBySupplierGoodsId(Long supplierGoodsId);

    Integer updateByPrimaryKeySelective(DuibaLiveSupplierGoodsAuditDto record);

    Integer updateByPrimaryKey(DuibaLiveSupplierGoodsAuditDto record);

    /**
     * 分页查询兑吧直播供应商商品审核列表
     * @param param 查询参数
     * @return 列表
     */
    List<DuibaLiveSupplierGoodsAuditDto> page(DuibaLiveSupplierGoodsAuditPageParam param);

    /**
     * 查询总数
     * @param param 查询参数
     * @return 总数
     */
    int countForPage(DuibaLiveSupplierGoodsAuditPageParam param);

    /**
     * 分页查询审核列表
     * @param param 搜索条件
     * @param count 是否查询总条数
     * @return 列表
     */
    PageResp<DuibaLiveSupplierGoodsAuditDto> pageWithCount(DuibaLiveSupplierGoodsAuditPageParam param, Boolean count);

    /**
     * 更新审核单
     *
     * @param record
     * @return
     */
    Integer updateAuditStatus(DuibaLiveSupplierGoodsAuditDto record);

    /**
     * 查询商品最近一条审核记录
     *
     * @param goodsId 商品Id
     * @return 审核记录
     */
    DuibaLiveSupplierGoodsAuditDto findRecentRecordByGoodsId(Long goodsId);

    /**
     * 查询商品最近一条成功的审核记录
     *
     * @param goodsId 商品Id
     * @return 审核记录
     */
    DuibaLiveSupplierGoodsAuditDto findRecentSuccessRecordByGoodsId(Long goodsId);

    /**
     * 根据商品列表查询商品最近一条审核记录
     *
     * @param goodsIds 商品Id列您
     * @return 审核记录 K: goodsId V:审核记录
     */
    Map<Long, DuibaLiveSupplierGoodsAuditDto> listRecentRecordByGoodsIds(List<Long> goodsIds);

    /**
     * 同步审核单通过后的ID回填、审核单状态变更
     *
     * @param supplierGoodsMngSyncDto
     * @return
     */
    Boolean syncAgreeAuditData(SupplierGoodsMngSyncDto supplierGoodsMngSyncDto) throws BizException;

}
