package cn.com.duiba.live.supplier.center.api.remoteservice.sku;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.supplier.center.api.dto.sku.AttributeLibraryDto;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteDuibaLiveAttributeLibraryService {
    List<AttributeLibraryDto> findAllAttributeLibrary();

    List<AttributeLibraryDto> findAttributeLibraryByIdList(List<Long> idList);

    /**
     * 查询指定app的规格列表
     *
     */
    List<AttributeLibraryDto> findAttributeLibrary();

    /**
     * 保存规格
     *
     * @param attributeLibraryDto
     * @return
     */
    Long saveAttributeLibrary(AttributeLibraryDto attributeLibraryDto) throws BizException;

    /**
     * 批量保存规格项
     * @param list
     * @return
     * @throws BizException
     */
    Map<String, Long> batchSave(List<AttributeLibraryDto> list) throws BizException;

    List<AttributeLibraryDto> findLibraryBySpec(List<String> specNameList);
}
