package cn.com.duiba.live.supplier.center.api.remoteservice.sku;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.supplier.center.api.dto.DuibaLiveSupplierGoodsSkuDto;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2022/01/10 14:03
 * @description 商品Sku - RPC服务
 */
@AdvancedFeignClient
public interface RemoteDuibaLiveGoodsSkuService {

    /**
     * 根据商品id查询sku信息
     *
     * @param goodsId 商品Id
     * @return sku 列表
     */
    List<DuibaLiveSupplierGoodsSkuDto> listByGoodsId(Long goodsId);

    /**
     * 根据商品id列表查询sku信息
     *
     * @param goodsIds 商品Id列表
     * @return sku 列表
     */
    List<DuibaLiveSupplierGoodsSkuDto> listByGoodsIds(List<Long> goodsIds);

    /**
     * 批量更新统一商品下的sku
     *
     * @param goodsId      商品Id
     * @param goodsSkuList 商品Sku列表
     * @return 更新结果
     */
    int batchUpdateByGoodsId(Long goodsId, List<DuibaLiveSupplierGoodsSkuDto> goodsSkuList);

}
