package cn.com.duiba.live.supplier.center.api.enums.goods;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhuenhui
 * @date 2022/01/10 14:25
 * @description 商品卡券类型
 */
@Getter
@AllArgsConstructor
public enum DuibaLiveGoodsCouponType {

    COMMON(0, "普通优惠券"),
    LINK(1, "链接类型优惠券"),
    REPEAT(2, "可重复优惠券"),
    CRYPTO_CARD(3, "卡密"),
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, DuibaLiveGoodsCouponType> enumMap = Collections.unmodifiableMap(
            Arrays.stream(DuibaLiveGoodsCouponType.values()).collect(Collectors.toMap(DuibaLiveGoodsCouponType::getType, Function.identity()))
    );

    public static DuibaLiveGoodsCouponType getByType(Integer type) {
        return enumMap.get(type);
    }

}
