package cn.com.duiba.live.supplier.center.api.enums.supplier;

import java.util.Arrays;
import java.util.Objects;

/**
 * @date:2022/1/7 15:27
 * @author:zhaozhanghai
 * @Description: 供应商 宝付通开户状态
 */
public enum DuibaLiveSupplierBftOpenStatusEnum {
    //    0-无状态 1-提交开户申请 2-开户申请成功 3-开户申请失败 4-上传资料成功 5-开户成功
    init(0, "无状态"),
    submit_apply(1, "提交开户申请"),
    apply_success(2, "开户申请成功"),
    apply_fail(3, "开户申请失败"),
    upload_data(4, "上传资料成功"),
    open_success(5, "开户成功");

    DuibaLiveSupplierBftOpenStatusEnum(Integer type, String desc) {
        this.status = type;
        this.desc = desc;
    }

    private Integer status;
    private String desc;

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    public static DuibaLiveSupplierBftOpenStatusEnum getByStatus(Integer status) {
        return Arrays.asList(values()).stream().filter(i -> Objects.equals(i.getStatus(), status)).findFirst().orElse(null);

    }
}
