package cn.com.duiba.live.supplier.center.api.params.goods;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhuenhui
 * @date 2022/01/13 11:30
 * @description 商品瀑布流查询列表参数
 */
@Data
public class DuibaLiveSupplierGoodsExportQueryParam implements Serializable {

    private static final long serialVersionUID = -3614357883800923283L;

    /**
     * 商品Id
     */
    private Long id;

    /**
     * 商品名称
     */
    private String name;

    /**
     * 创建时间 - 开始时间
     */
    private Date startTime;
    /**
     * 创建时间 - 结束时间
     */
    private Date endTime;

    /**
     * 上架/下架
     */
    private Integer enable;

    /**
     * 商品类型
     * object-实物 card-卡券
     */
    private String type;

    /**
     * 商品备注
     */
    private String memo;

    /**
     * 经营类目（目前只有实物有）
     * 1-食品酒水 2-美妆护肤 3-数码电器 4-宠物用品 5-百货家清 6-母婴
     */
    private Integer itemClassifyId;

    /**
     * 供应商ID tb_supplier.id
     */
    private Long distributorId;

    /**
     * 起始Id
     */
    private Long startId;

}
