package cn.com.duiba.live.supplier.center.api.enums.goods;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhuenhui
 * @date 2022/01/10 14:25
 * @description 商品 - 上下架状态
 */
@Getter
@AllArgsConstructor
public enum DuibaLiveGoodsUpType {

    OFF(0, "下架"),
    UP(1, "上架"),
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, DuibaLiveGoodsUpType> enumMap = Collections.unmodifiableMap(
            Arrays.stream(DuibaLiveGoodsUpType.values()).collect(Collectors.toMap(DuibaLiveGoodsUpType::getType, Function.identity()))
    );

    public static DuibaLiveGoodsUpType getByType(Integer type) {
        return enumMap.get(type);
    }

}
