package cn.com.duiba.live.supplier.center.api.params;

import cn.com.duiba.live.supplier.center.api.base.BasePage;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * @author fss
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class DuibaLiveMngSupplierGoodsAuditPageParam extends BasePage implements Serializable {

    private static final long serialVersionUID = 4730395480318138997L;

    /**
     * 兑吧商品ID
     */
    private Long duibaItemId;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 提交开始时间
     */
    private Date submitStartTime;

    /**
     * 提交结束时间
     */
    private Date submitEndTime;

    /**
     * 商品类型,coupon：优惠券 object：实物
     */
    private String goodsType;

    /**
     * 商品类目
     */
    private Long itemClassifyId;

    /**
     * 是否上架:0下架,1上架
     */
    private Integer enableState;

    /**
     * 审核状态:0待审核,1审核通过,2审核拒绝,3取消申请
     */
    private Integer auditState;

    /**
     * 审核类型:1兑吧审核,2供应商审核
     */
    private Integer auditType;

    /**
     * 供应商ID
     */
    private Long supplierId;
}
